﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/private/Private.Master" CodeBehind="listadotrabajo.aspx.vb" Inherits="Web.listadotrabajo" Theme="Web" EnableEventValidation="false" %>

<%@ Register Assembly="System.Web.Extensions, Version=1.0.61025.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35" Namespace="System.Web.UI" TagPrefix="asp" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register Src="~/private/traceability/controles/cu-codigoopcion.ascx" TagName="cu_codigoopcion" TagPrefix="uc" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

    <asp:UpdatePanel runat="server" ID="UpdatePanelListadoTrabajo" UpdateMode="Conditional" ChildrenAsTriggers="false">
        <ContentTemplate>

            <script type="text/javascript">

                function findGestures_worklist() {
                    var active = <%= GestureControlIsActiveForJs %>;
                    if (active === false) {
                        return;
                    }
                    setInterval(
                        function () {
                            $.ajax({
                                type: "POST",
                                url: '../../Services/GestureService.asmx/GetGestures',
                                data: '{jbcUser:"US00000001"}',
                                contentType: "application/json; charset=utf-8",
                                dataType: "json",
                                success: function (response) {
                                    if (response.d.length === 0) {
                                        return;
                                    }

                                    var gestures = response.d;
                                    __doPostBack('ctl00$ContentPlaceHolder1$btnGestural', '[' + gestures + ']');
                                },
                                failure: function (response) {
                                    alert(response.d);
                                }
                            });
                        },
                        500);
                }

                findGestures_worklist();

            </script>

            <!-- Ficha de una operación o tarea -->
            <asp:Panel ID="panelCodeOption" runat="server" CssClass="block trace content-inner" Visible="false">

                <div class="table-styles-block">
                    <div class="station-demo-block">
                        <div class="station-details-table">
                            <uc:cu_codigoopcion ID="cu_codigoopcion" runat="server" />
                        </div>
                    </div>
                </div>

            </asp:Panel>

            <!-- Listado de trabajo -->
            <asp:Panel ID="panelWorkList" runat="server" CssClass="block trace" Visible="true">
                <div class="table-styles-block">
                    <div class="add-panel panel-big">
                        <h2><%= Translator.Translate("TRACE_WORKLIST_TITLE")%></h2>
                    </div>
                    <div class="content" style="height: calc(100vh - 115px);">
                        <div class="content-inner">
                            <div class="accordion-holder">
                                <ajaxToolkit:Accordion ID="Accordion2" runat="server" CssClass="open-close" HeaderCssClass="open-close-item " HeaderSelectedCssClass="open-close-item no-border-bottom active" ContentCssClass="open-close-item slide" RequireOpenedPane="true" Visible="true">
                                    <Panes>
                                        <ajaxToolkit:AccordionPane ID="AccordionPane1" runat="server">
                                            <Header><a class="opener opener-blue" href="#"><%= Translator.Translate("TRACE_WORKLIST_CONFIG_WORKPLACE")%></a></Header>
                                            <Content>
                                                <div class="options-block">
                                                    <div class="elements-group wide-block">
                                                        <div class="option-item">
                                                            <label for="select1"><%= Translator.Translate("TRACE_WORKLIST_WORKSTATION")%></label>
                                                            <asp:DropDownList ID="ddlWorkPlace" name="select1" runat="server" CssClass="form-item blue" AutoPostBack="true" Width="190px" Style="float: right;"></asp:DropDownList>
                                                        </div>
                                                        <div class="option-item">
                                                            <label for="select3"><%= Translator.Translate("TRACE_WORKLIST_TOOLS")%></label>
                                                            <asp:DropDownList ID="ddlHerramientas" name="select2" runat="server" CssClass="form-item blue" AutoPostBack="true" Width="190px" Style="float: right;"></asp:DropDownList>
                                                        </div>
                                                        <div class="option-item">
                                                            <label><%= Translator.Translate("TRACE_WORKLIST_SUPPORT")%></label>
                                                            <asp:TextBox ID="Soporte_Modelo" runat="server" Style="font-size: 12px;" Width="190px"></asp:TextBox>
                                                        </div>
                                                    </div>
                                                    <div class="elements-group medium-block">
                                                        <div class="option-item">
                                                            <label for="select2"><%= Translator.Translate("TRACE_WORKLIST_STATION")%></label>
                                                            <asp:DropDownList ID="ddlEstacion" name="select3" runat="server" CssClass="form-item blue" AutoPostBack="true" Width="160px" Style="float: right;"></asp:DropDownList>
                                                        </div>
                                                        <div class="option-item">
                                                            <label for="select5"><%= Translator.Translate("TRACE_WORKLIST_PORT")%></label>
                                                            <asp:DropDownList ID="ddlPuerto" name="select4" runat="server" CssClass="form-item blue" AutoPostBack="true" Width="160px" Style="float: right;"></asp:DropDownList>
                                                        </div>
                                                        <div class="option-item">
                                                            <label for="select4"><%= Translator.Translate("TRACE_WORKLIST_MODE")%></label>
                                                            <asp:DropDownList ID="ddlModo" name="select5" runat="server" CssClass="form-item blue" AutoPostBack="true" Width="160px" Style="float: right;"></asp:DropDownList>
                                                        </div>
                                                    </div>
                                                </div>
                                            </Content>
                                        </ajaxToolkit:AccordionPane>

                                        <ajaxToolkit:AccordionPane ID="AccordionPane2" runat="server">
                                            <Header><a class="opener opener-blue" href="#"><%= Translator.Translate("TRACE_WORKLIST_ADVANCED_SEARCH")%></a></Header>
                                            <Content>
                                                <div class="options-block">
                                                    <div class="elements-group wide-block">
                                                        <div class="option-item">
                                                            <label><%= Translator.Translate("TRACE_WORKLIST_CODEOPTION")%></label>
                                                            <asp:TextBox ID="Codigo" runat="server" Width="160px"></asp:TextBox>
                                                        </div>
                                                        <div class="option-item">
                                                            <label><%= Translator.Translate("TRACE_WORKLIST_TITTLE")%></label>
                                                            <asp:TextBox ID="Titulo" runat="server" Width="160px"></asp:TextBox>
                                                        </div>
                                                    </div>
                                                    <div class="elements-group medium-block">
                                                        <div class="option-item">
                                                            <label for="select6"><%= Translator.Translate("TRACE_WORKLIST_STATE")%></label>
                                                            <asp:DropDownList ID="ddlEstado" name="select6" runat="server" CssClass="form-item blue" AutoPostBack="true" Width="160px" Style="float: right;"></asp:DropDownList>
                                                        </div>
                                                    </div>
                                                </div>
                                            </Content>
                                        </ajaxToolkit:AccordionPane>
                                    </Panes>
                                </ajaxToolkit:Accordion>
                            </div>
                            <div class="result-table-holder js-table-holder" style="min-height: calc(100vh - 320px);">
                                <div class="result-inner">
                                    <div class="result-table-info">
                                        <div class="result-count">
                                            <p>
                                                <asp:Label ID="num_resultados" runat="server" Text="Resultado (0 elementos)"></asp:Label>
                                            </p>
                                        </div>
                                        <div class="result-buttons">
                                            <asp:LinkButton ID="btnComenzar" runat="server" CssClass="btn btn-green" Visible="false">Start</asp:LinkButton>
                                            <asp:LinkButton ID="btnActualizar" runat="server" CssClass="btn btn-blue"><%= Translator.Translate("TRACE_WORKLIST_UPDATE")%></asp:LinkButton>
                                            <asp:LinkButton ID="btnResetFiltros" runat="server" CssClass="btn btn-blue"><%= Translator.Translate("TRACE_WORKLIST_CLEAR_FILTERS")%></asp:LinkButton>
                                        </div>
                                    </div>
                                    <div class="result-table js-height-block">
                                        <div class="result-table-inner">
                                            <div class="table-box table-body">
                                                <div class="table-container jcf-scrollable">

                                                    <!--- GridViewLstOpciones-->
                                                    <asp:UpdatePanel runat="server" ID="UpdatePanelGridView" UpdateMode="Conditional" ChildrenAsTriggers="false">
                                                        <ContentTemplate>

                                                            <asp:LinkButton ID="btnGestural" runat="server" CssClass="btn btn-green" Visible="true" Style="display: none;" />

                                                            <asp:GridView ID="GridViewLstOpciones" CssClass="default-table" SkinID="GridviewSkinLlistatV2" runat="server" DataKeyNames="CODEOPTION" UseAccessibleHeader="false" PageSize="15">
                                                                <Columns>
                                                                    <asp:TemplateField HeaderText="Código" ItemStyle-CssClass="" HeaderStyle-CssClass="thead" ItemStyle-Width="110">
                                                                        <ItemTemplate>
                                                                            <%#If(InStr(CStr(Eval("CodeOption")), "-") > 0, "&ensp;", String.Empty)%>
                                                                            <asp:LinkButton ID="lnkOpcion" CssClass="link-underline absolute-lightbox" runat="server" CommandName="CODEOPTION" CommandArgument='<%#Eval("CodeOption")%>'><%# If(InStr(CStr(Eval("CodeOption")), "-") > 0, CStr(Eval("CodeOption")), "<strong>" & CStr(Eval("CodeOption")) & "</strong>") %></asp:LinkButton>
                                                                        </ItemTemplate>
                                                                    </asp:TemplateField>
                                                                    <asp:TemplateField HeaderText="Título" ItemStyle-CssClass="" HeaderStyle-CssClass="thead">
                                                                        <ItemTemplate>
                                                                            <asp:Label CssClass="CampDades" ID="lblrowFieldGridTitulo" runat="server" ToolTip='<%# Bind("Title")%>' Text='<%# If(InStr(CStr(Eval("CodeOption")), "-") > 0, CStr(Eval("Title")), "<strong>" & CStr(Eval("Title")) & "</strong>") %>'></asp:Label>
                                                                        </ItemTemplate>
                                                                    </asp:TemplateField>
                                                                    <asp:TemplateField HeaderText="Herramienta" ItemStyle-CssClass="" HeaderStyle-CssClass="thead">
                                                                        <ItemTemplate>
                                                                            <asp:Label CssClass="CampDades" ID="lblrowFieldGridHerramienta" runat="server" ToolTip='<%# Bind("RequiredTool")%>' Text='<%# Bind("RequiredTool")%>'></asp:Label>
                                                                        </ItemTemplate>
                                                                    </asp:TemplateField>
                                                                    <asp:TemplateField HeaderText="Soporte" ItemStyle-CssClass="" HeaderStyle-CssClass="thead">
                                                                        <ItemTemplate>
                                                                            <asp:Label CssClass="CampDades" ID="lblrowFieldGridSoporte" runat="server" ToolTip='<%# Bind("RequiredSupport")%>' Text='<%# Eval("RequiredSupport").Replace(SeparadorCBSoporte, " " & SeparadorCBSoporte & " ")%>'></asp:Label>
                                                                        </ItemTemplate>
                                                                    </asp:TemplateField>
                                                                    <asp:TemplateField HeaderText="Nº tareas" ItemStyle-CssClass="" HeaderStyle-CssClass="thead" ItemStyle-Width="60">
                                                                        <ItemTemplate>
                                                                            <asp:Label CssClass="CampDades" ID="lblrowFieldGridNumTareas" runat="server" ToolTip='<%# If(Eval("NumTasks") = 0, String.Empty, CStr(Eval("NumTasks")))%>' Text='<%# If(Eval("NumTasks") = 0, String.Empty, If(InStr(CStr(Eval("CodeOption")), "-") > 0, CStr(Eval("NumTasks")), "<strong>" & CStr(Eval("NumTasks")) & "</strong>")) %>'></asp:Label>
                                                                        </ItemTemplate>
                                                                    </asp:TemplateField>
                                                                    <asp:TemplateField HeaderText="Estado" ItemStyle-CssClass="" HeaderStyle-CssClass="thead">
                                                                        <ItemTemplate>
                                                                            <asp:Label CssClass="CampDades" ID="lblrowFieldGridEstado" runat="server" ToolTip='<%# Bind("State")%>' Text='<%# If(InStr(CStr(Eval("CodeOption")), "-") > 0, CStr(Eval("State")), "<strong>" & CStr(Eval("State")) & "</strong>") %>'></asp:Label>
                                                                        </ItemTemplate>
                                                                    </asp:TemplateField>
                                                                    <asp:TemplateField HeaderText="Ficha" ItemStyle-CssClass="" HeaderStyle-CssClass="thead">
                                                                        <ItemTemplate>
                                                                            <asp:LinkButton ID="lnkFicha" runat="server" CommandName="FICHA" CommandArgument='<%#Eval("CodeOption")%>' CssClass="btn" Width="60"><%= Translator.Translate("TRACE_WORKLIST_GRIDVIEW_VIEW_BUTTON")%></asp:LinkButton>
                                                                        </ItemTemplate>
                                                                    </asp:TemplateField>
                                                                    <asp:ButtonField Text="DobleClick" CommandName="DobleClick" Visible="false" />
                                                                </Columns>
                                                            </asp:GridView>

                                                            <!--- Controles ocultos -->
                                                            <asp:HiddenField ID="hdnGridViewLstOpciones_SelectedIndexClient" runat="server" Value="0" />
                                                            <asp:HiddenField ID="hdnGridViewLstOpciones_SelectedPageIndexClient" runat="server" Value="0" />

                                                        </ContentTemplate>
                                                        <Triggers>
                                                            <asp:AsyncPostBackTrigger ControlID="btnGestural" EventName="Click" />
                                                        </Triggers>
                                                    </asp:UpdatePanel>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </asp:Panel>

        </ContentTemplate>
    </asp:UpdatePanel>

    <ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderListadoTrabajo" TargetControlID="UpdatePanelListadoTrabajo" BehaviorID="animation" runat="server">
        <Animations>    
            <OnUpdated>
                <Sequence>
                    <ScriptAction Script="initRefreshFunctions($('div.trace')); findGestures_worklist();" />
                </Sequence>
            </OnUpdated>
        </Animations>
    </ajaxToolkit:UpdatePanelAnimationExtender>

    <!-- Update progress -->
    <asp:UpdateProgress ID="UpdateProgressListadoTrabajo" runat="server" AssociatedUpdatePanelID="UpdatePanelListadoTrabajo" DisplayAfter="100" Visible="true">
        <ProgressTemplate>
            <asp:Image ID="img_ajax_loading_MenuStation" runat="server" ImageUrl="~/images/ajax-loading.gif" CssClass="ajax_loading_centered" />
        </ProgressTemplate>
    </asp:UpdateProgress>

</asp:Content>
